/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.furniture;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;

public class FurnitureEntityAssetsByMaterialType {
    private Map<GameMaterialType, List<FurnitureEntityAsset>> byMaterialType = new EnumMap<GameMaterialType, List<FurnitureEntityAsset>>(GameMaterialType.class);

    public FurnitureEntityAssetsByMaterialType() {
        for (GameMaterialType gameMaterialType : GameMaterialType.values()) {
            this.byMaterialType.put(gameMaterialType, new ArrayList());
        }
    }

    public void add(FurnitureEntityAsset asset) {
        List<GameMaterialType> materialTypes = asset.getValidMaterialTypes();
        if (materialTypes == null) {
            throw new RuntimeException("Material types must be specified for " + asset);
        }
        for (GameMaterialType materialType : materialTypes) {
            this.byMaterialType.get((Object)materialType).add(asset);
        }
    }

    public FurnitureEntityAsset get(FurnitureEntityAttributes attributes) {
        List<FurnitureEntityAsset> assets = this.byMaterialType.get((Object)attributes.getPrimaryMaterialType());
        if (assets.size() == 0) {
            System.err.println("Could not find applicable asset for " + attributes.toString());
            return null;
        }
        return assets.get(Math.abs((int)attributes.getSeed()) % assets.size());
    }

    public List<FurnitureEntityAsset> getAll(FurnitureEntityAttributes attributes) {
        return this.byMaterialType.get((Object)attributes.getPrimaryMaterialType());
    }
}

